* Section 4.3: statistics cited in text
* Date last edited: 02 October 2018
* File author: Mary-Alice Doyle

*cd [specify filepath for working directory]

**************
* Average net benefit to cardholders
**************
* Point estimate of $2 net benefit (not significantly different from zero), with CI
preserve
do ".\Stata files\Preferred net benefit.do"
ci netbenefit if idtag==1 & ccown==1 [aw=w1]
table idtag if idtag==1 & ccown==1 [pw=w1], c(median netbenefit)
restore

*************
* Net cost to banks
*************
* Same as preferred net benefit, with 2 differences:
//1. but using costs of funds instead of value of interst-free period
//2. cost of rewards is assumed lower if redeemed for non-gift vouchers or flights
//and zero if respondent never redeems rewards points
do ".\Stata files\Setup.do"
preserve
quietly {
drop if ccown==0
drop if ccmainfee>=1000

* Step 1: for rewards points
***************
* Annual spend based on monthly total
gen annualspend1 = (q7e / 0.99) * 12 if q7e>=0

gen ccrebate1 = ccmainrebatepct
replace ccrebate1 = ccmain_flightrebate if q7a==3 & ccmain_flightrebate!=.
label var ccrebate1 "percent rewards rebate, based on redemption for flights for respondents who normally redeem for flights; $100 gift voucher for all other respondents"


* Step 2: for annual fee
***************
*Indicator for whether discounted/waived
gen annualfee_d = .
replace annualfee_d = 1 if ccown == 1
replace annualfee_d = 0 if q7d == 3 | q7d == 4
replace annualfee_d = .5 if q7d == 2
label define annualfee_d 0 "waived (0)" 1 "everyone else - incl zero annual fee (1)"
label val annualfee_d annualfee_d

* $ value of annual fee
gen annualfee = annualfee_d * ccmainfee if ccmainfee!=-5 & ccmainfee!=-1
label var annualfee "$ value of annual fee paid, adjusted for waived/discounted"

* Step 3: for portion of month money is borrowed for
***************
gen ifp_used = .
replace ifp_used = 1 if ccrepay == 2
replace ifp_used = 3 if ccrepay == 4
replace ifp_used = 0 if ccrepay == 5
replace ifp_used = 30/ccmainday if ccrepay == 1 & ccmainday >=0
replace ifp_used = 0.6 if ccmainday==-5 & ccrepay==1
replace ifp_used = 15/ccmainday if ccrepay == 3 & ccmainday>=0
replace ifp_used = 0.25 if ccrepay == 3 & ccmainday==-5
replace ifp_used = 1.5 if ccrepay == 6

* Cost of funds (instead of alternative interest rate)
* overnight indexed swap rate from RBA table f01hist - 1.5% in nov 2016
gen costoffunds = 0.015


* Step 4: for interest paid
******************
gen interest_freq1 = 0 if ccown==1
replace interest_freq1 = 1 if !inlist(ccrepay,5,6) & q7f>0
replace interest_freq1 = 3 if ccrepay==6
replace interest_freq1 = 12 if ccrepay==5

gen interest_paid =0 if q7b!=-2 & q7f!=-2 & q7b!=-1

********
* CALCULATIONS
********


		* Step 1
		******************
		gen rewards_annualval = 0
		replace rewards_annualval = ccrebate1/100* annualspend  if annualspend1!=. & ccmainrebate>0
		replace rewards_annualval = . if annualspend1==.
		* assume cost of rewards not redeemed for flights or gift card is 70% of value (just an estimate, I don't have any data on this);
		* and cost is zero for people who have neverr redeemed their rewards
		replace rewards_annualval = rewards_annualval *.7 if !inlist(q7a,1,3)
		replace rewards_annualval = 0 if q7a==7
				
		* Step 2.5: Net value of payment function
		******************
		gen netpmtfunction = rewards_annualval - annualfee

		* Step 3: Interest-free period
		*******************
		* Value of interest free period - assuming balance is accrued in the middle of the month (day 15)
		gen ifp_potential = annualspend1 * costoffunds *(ccmainday-15)/365 if ccmainday >0
		label var ifp_potential "Value of IFP if respondent pays off on the due date"
		replace ifp_potential = 0 if ccmainday==0
		*^ There are two credit cards in the sample which do not have an interest-free period (interest applies immediately after purchase)
		
		gen ifp_value = ifp_potential * ifp_used
		label var ifp_value "Actual value of IFP based on reported fequency of cc repayments (from ccrepay)"
		
		* Step 4: Interest paid
		*********************
		replace interest_paid = q7f * interest_freq1 if q7f>=0

		
		* Step 4.5: Net value of borrowing function
		********************
		gen netborrowingvalue = ifp_value - interest_paid
		* ^ we are missing data on 189 respondents - 18 per cent of cc holders (some we don't know maincc, 59 prefer not to answer credit card interst paid, 16 not sure/someone else looks after ccrepay, 129 prefer not to answer total card spend)

		* STEP 5: put everything together
		********
		gen netbankcost = netpmtfunction + netborrowingvalue

	}
	
ci netbankcost if idtag==1  [aw=w1]
* average cost to banks is -$42 (ie, a profit of $42 per customer per year) but this is sensitive to outliers. 
* BUT this calculation is imperfect.  
* also not adjusting for risk of non-repayment on loans

***********
* Annual fees
***********
table ccown if idtag==1 [pw=w1], c(mean annualfee)
restore


drop if ccown==0
* Alternative annual fee incl 1000+ and based on advertised fees
***************
table idtag if ccmainfee!=-5 & idtag==1 & ccown==1 [pw=w1], c(mean ccmainfee)

**********
* Annual spending
***********

drop if ccmainfee>=1000
gen annualspend1 = (q7e / 0.99) * 12 if q7e>=0
table idtag if idtag==1 & ccown==1 [pw=w1], c(mean annualspend1)
* ^ on average cc holders spend $22k on their main card each year

* ratio of main to all credit card spending:
gen ccmainpayment = payamt if payamt>0 & (paymethx==5 | paymethx==4) & cc_used == ccmain
gen ccpayment = payamt if payamt>0 & (paymethx==5 | paymethx==4) 
egen sumccspend = total(ccpayment), by(id)
egen sumccmainspend = total(ccmainpayment), by(id)
gen ccmainshare = sumccmainspend/sumccspend 
table idtag if idtag==1 & ccown==1 & ccpayment!=. [pw=w1], c(mean ccmainshare mean sumccmainspend mean sumccspend)
* ^ main credit card is used for ~75% of credit card payments on average
* So 1/.75 * 22.3k = ~30k spent on credit cards per year
*Note: I choose not to use total diary CC spending (788*52) because I trust the (less noisy) monthly spend from q7e more.
